<?php
require_once("../../autoloader.php");
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header("Access-Control-Allow-Methods: POST, GET, OPTIONS, PUT, DELETE");
header("Allow: POST, OPTIONS, PUT, DELETE, GET");
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Access-Control-Allow-Origin");

$headers = apache_request_headers();
$response = array();
$controller = new SubscriberModel;

date_default_timezone_set('Africa/Lagos');

// Get the input data for user ID
$input = json_decode(file_get_contents('php://input'), true);
$userValue = isset($input['userId']) ? $input['userId'] : "13394";

if ($userValue) {
   $currentDate = date('Y-m-d');

    // Call each of the individual functions to get the required data
    $totalWalletTopup = json_decode($controller->getTotalWalletTopup($userValue), true);
    $totalTransactions = $controller->TotalTransactions($userValue);
    $totalSpent = $controller->getTotalSpent($userValue);
    $totalMoneyFundedWeekly = json_decode($controller->getTotalMoneyFundedWeekly($userValue), true);
    $totalMoneyFundedMonthly = json_decode($controller->getTotalMoneyFundedMonthly($userValue), true);

    // New data metrics for today
    $totalDataSold = $controller->getTotalDataSold($userValue, $currentDate);
    $totalDataGBSold = $controller->getTotalDataGBSold($userValue, $currentDate);
    $totalAirtime = $controller->getTotalAirtime($userValue, $currentDate);

    // Create an associative array to hold all the results
    $summary = array(
        'total_wallet_topup' => $totalWalletTopup ?? '0',
        'total_transactions' => $totalTransactions ?? '0',
        'total_spent' => $totalSpent ?? '0',
        'total_money_funded_weekly' => $totalMoneyFundedWeekly ?? '0',
        'total_money_funded_monthly' => $totalMoneyFundedMonthly ?? '0',
        'total_data_sold' => $totalDataSold ?? '0',
        'total_data_gb_sold' => $totalDataGBSold ?? '0',
        'total_airtime' => $totalAirtime ?? '0'
    );
    // Convert the array to JSON format and return
    header('Content-Type: application/json');
    file_put_contents('lol.txt',json_encode($summary));
    echo json_encode($summary);
} else {
    // Return an error response if userValue is not set
    $response['error'] = "User ID is required.";
    echo json_encode($response);
}
?>
