<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
header('Access-Control-Allow-Headers: Authorization, Content-Type');

require_once '../config/database.php';

// Simple token-based authentication (replace with proper auth in production)
$token = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
if (strpos($token, 'Bearer ') !== 0 || substr($token, 7) !== 'your-auth-token') {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

$request = $_SERVER['REQUEST_URI'];
$method = $_SERVER['REQUEST_METHOD'];

switch ($request) {
    case '/api/stories':
        require_once 'stories.php';
        break;
    case '/api/posts':
        require_once 'posts.php';
        break;
    default:
        http_response_code(404);
        echo json_encode(['error' => 'Not Found']);
        break;
}
?>