<?php
require_once "../database.php";
header('Content-Type: application/json');

$data = json_decode(file_get_contents("php://input"), true);
$id = $data['id'] ?? null;

if ($id) {
    $stmt = $conn->prepare("UPDATE news SET title = ?, content = ?, status = ? WHERE id = ?");
    $success = $stmt->execute([
        $data['title'],
        $data['content'],
        $data['status'],
        $id
    ]);

    echo json_encode([
        "status" => $success ? "success" : "error",
        "message" => $success ? "News updated" : "Update failed"
    ]);
} else {
    echo json_encode(["status" => "error", "message" => "Invalid data"]);
}
?>
