<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

require_once "../database.php";

try {
    // Join transactions with users to get the email
    $stmt = $conn->prepare("
        SELECT 
            transactions.*, 
            users.email 
        FROM 
            transactions 
        INNER JOIN 
            users 
        ON 
            transactions.user_id = users.id 
        ORDER BY 
            transactions.created_at DESC
    ");
    $stmt->execute();
    $transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($transactions);
} catch (PDOException $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
?>
