<?php
    require_once("../../autoloader.php");
    header('Access-Control-Allow-Origin: *');
    header('Content-Type: application/json');
    header("Access-Control-Allow-Methods: POST");
    header("Allow: POST, OPTIONS, PUT, DELETE");
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Access-Control-Allow-Origin");

    $headers = apache_request_headers();
    $response = array();
    $controller = new SubscriberModel;
   
    date_default_timezone_set('Africa/Lagos');
          
// Get the current URL path
$currentPath = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

// Split the path into an array using the '/' delimiter
$pathSegments = explode('/', trim($currentPath, '/'));

// Find the position of the 'user' segment in the path
$userIndex = array_search('user', $pathSegments);

// Extract the user value
$userValue = isset($pathSegments[$userIndex + 1]) ? $pathSegments[$userIndex + 1] : null;

if ($userValue) {
   $userId = isset($_GET['user']) ? $_GET['user'] : null;


 $result = $controller->getUserWallet($userValue);
 if($result["status"]=="fail"){
        header('HTTP/1.0 400 Invalid Network Id');
        $response['status']="fail";
        $response['msg'] = "The Network id is invalid";
        echo json_encode($response);
        exit();
    }
    else{
            
       $response = array(
           "status"=> "success",
      "total_worth" => strval(round((float)$result["value"])),
       "commission" => strval(round((float)$result["commission"])),
         "cashback_balance" => strval(round((float)$result["cashback_balance"])),
           "total_withdrawn_cashback" => strval(round((float)$result["total_withdrawn_cashback"])),
             "total_withdrawn_referral" => strval(round((float)$result["total_withdrawn_referral"])),
               "sum_total" => strval(round((float)$result["sum_total"])),
       "total_deposit" => "10");
       $jsonData = json_encode($response, JSON_PRETTY_PRINT);
    file_put_contents("airtime_fail_log.txt",$jsonData);
    echo $jsonData;
    }

    
} else {
    
    $response = array('status' => 'error', 'message' => 'Invalid request method');
    echo json_encode($response);
}


?>