<?php
require_once("../../autoloader.php");
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header("Access-Control-Allow-Methods: POST,GET");
header("Allow: POST,GET, OPTIONS, PUT, DELETE");
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Access-Control-Allow-Origin");

$headers = apache_request_headers();
$response = array();
$controller = new SubscriberModel;

date_default_timezone_set('Africa/Lagos');
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $result = $controller->getUserTransaction(3);
    echo json_encode($result);
    
}
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validate and sanitize input
    if (!isset($_POST['user_id']) || !isset($_POST['page_num'])) {
        http_response_code(400); // Bad Request
        echo json_encode(["status" => "error", "message" => "Missing user_id or page_num."]);
        exit();
    }

    $id = $_POST['user_id'];
    $number = (int) $_POST['page_num'];
    
    // Write page number to a file (optional)


    // Retrieve user transactions
    $result = $controller->getUserTransactionMore($id,$number);
    file_put_contents("anumbemorer.txt", json_encode($number));
    // Check if the result is an array and handle slicing based on page_num
    if (is_array($result) && count($result) > 0) {
       

        // Iterate through transactions to modify as needed
        foreach ($result as &$transaction) {
            // Check for the specific service names and add corresponding fields
            if ($transaction['servicename'] === 'Exam Pin') {
                $apiResponseLog = json_decode($transaction['api_response_log'], true);
                if (isset($apiResponseLog['pins'])) {
                    // Extract pin, cleaning up the string
                    $transaction['pin'] = trim($apiResponseLog['pins']);
                }
            } elseif ($transaction['servicename'] === 'Electricity Bill') {
                $apiResponseLog = json_decode($transaction['api_response_log'], true);
                if (isset($apiResponseLog['data']['transaction']['meter_token'])) {
                    // Extract meter_token
                    $transaction['token'] = $apiResponseLog['data']['transaction']['meter_token'];
                }
            }
        }

        $response["status"] = "success";
        $response["transactions"] = $result; // Set transactions to response

        // Return success response
        echo json_encode($response);
        exit();
    } else {
        // Handle case where no transactions are found
        $response["status"] = "error";
        $response["message"] = "No transactions found for the user.";
        echo json_encode($response);
        exit();
    }
}

// If the request method is not POST, return method not allowed
http_response_code(405); // Method Not Allowed
echo json_encode(["status" => "error", "message" => "Method not allowed."]);
exit();
?>
