<?php
require_once("../../autoloader.php");
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header("Access-Control-Allow-Methods: POST");
header("Allow: POST, OPTIONS, PUT, DELETE");
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Access-Control-Allow-Origin");

$response = array();
$controller = new SubscriberModel;

date_default_timezone_set('Africa/Lagos');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Get POST data
    $nin = trim($_POST['nin']);
    $bvn = trim($_POST['bvn']); // Added BVN field
    $fullname = filter_var(trim($_POST['fullname']), FILTER_SANITIZE_STRING);
    $email = filter_var(trim($_POST['email']), FILTER_SANITIZE_EMAIL);
    $phone = trim($_POST['phone']);
    $address = filter_var(trim($_POST['address']), FILTER_SANITIZE_STRING);
    $dob = '03-Oct-1993'; // Assuming DOB is static for this example
    $chargeAmount = '8';
    
    // Determine KYC type based on provided values
    if (!empty($nin) && !empty($bvn)) {
        $kyctype = "Both";
    } elseif (!empty($nin)) {
        $kyctype = "NIN";
    } elseif (!empty($bvn)) {
        $kyctype = "BVN";
    } else {
        $response['status'] = 'fail';
        $response['msg'] = 'Either NIN or BVN must be provided.';
        echo json_encode($response);
        exit();
    }

    // Validate phone number (exactly 11 digits)
    if (!preg_match('/^\d{11}$/', $phone)) {
        $response['status'] = 'fail';
        $response['msg'] = 'Invalid phone number. It must be exactly 11 digits.';
        echo json_encode($response);
        exit();
    }

    // Validate NIN if provided (exactly 11 digits)
    if (!empty($nin) && !preg_match('/^\d{11}$/', $nin)) {
        $response['status'] = 'fail';
        $response['msg'] = 'Invalid NIN number. It must be exactly 11 digits.';
        echo json_encode($response);
        exit();
    }

    // Validate BVN if provided (exactly 11 digits)
    if (!empty($bvn) && !preg_match('/^\d{11}$/', $bvn)) {
        $response['status'] = 'fail';
        $response['msg'] = 'Invalid BVN number. It must be exactly 11 digits.';
        echo json_encode($response);
        exit();
    }

    // Validate email format
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $response['status'] = 'fail';
        $response['msg'] = 'Invalid email format.';
        echo json_encode($response);
        exit();
    }

    // Check if fullname and address are valid (no empty inputs)
    if (empty($fullname) || empty($address)) {
        $response['status'] = 'fail';
        $response['msg'] = 'Name or address cannot be empty.';
        echo json_encode($response);
        exit();
    }

    // Insert details using controller
    $result = $controller->insertKycDetails($email, $kyctype, $dob, $nin, $bvn); // Pass both NIN and BVN
    $ress = $result; // Decoding to associative array

    // Log result
    file_put_contents("airtime_fail_log.txt", json_encode($ress, JSON_UNESCAPED_SLASHES));
    if ($ress['status'] === "fail") {
        if (strpos(strtolower($ress['message']), 'Database error') !== false) {
            $response['msg'] = 'User already submitted';
        } else {
            $response['msg'] = 'User already submitted';
        }

        $response['status'] = 'fail';
        header('HTTP/1.0 200 Invalid Network Id');
        file_put_contents("airtime_fail_log.txt", json_encode($response));
        echo json_encode($response);
        exit();
    } else {
        $response = array('status' => 'success');
        $data = array(
            "status" => "success",
        );

        $jsonString = json_encode($data, JSON_UNESCAPED_SLASHES);
        echo json_encode($result);
        exit();
    }

} else {
    $response = array('status' => 'error', 'message' => 'Invalid request method');
    file_put_contents("airtime_fail_log.txt", json_encode($response));
    echo json_encode($response);
}
?>
