<?php
header('X-Content-Type-Options: nosniff');
header('X-Frame-Options: DENY');
header('X-XSS-Protection: 1; mode=block');

class UserController {
    private static function connect() {
        // Replace with your actual database connection details
        return new PDO('mysql:host=localhost;dbname=wapaycom_update', 'wapaycom_update', 'rtMO7!NLci#m', [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_OBJ
        ]);
    }

    public function fetchUser($id) {
        try {
            $dbh = self::connect();
            $id = (int) $id;

            $query = "SELECT * FROM subscribers WHERE sId = :id";
            $stmt = $dbh->prepare($query);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $stmt->execute();
            $result = $stmt->fetch();

            if ($result) {
                $response = [
                    'status' => 'success',
                    'id' => strval($result->sId),
                    'user_name' => $result->SUsername ?? 'Unknown',
                    'full_name' => trim($result->sFname . ' ' . $result->sLname) ?? 'No Name',
                    'fname' => $result->sFname ?? 'First',
                    'lname' => $result->sLname ?? 'Last',
                    'email' => $result->sEmail ?? 'dannvtu@gmail.com',
                    'image_name' => $result->sImage ?? 'https://dannvtu.com.ng/userimages/default.jpg',
                    'user_status' => $result->sRegStatus == 3 ? 'Active' : 'Inactive',
                    'phone' => $result->sPhone ?? '00000000000',
                    'age' => $result->sAge ?? '0',
                    'sex' => $result->sSex ?? 'Homo Sapien',
                    'address' => $result->sAddress ?? 'Not Provided',
                    'date_created' => $result->sRegDate ?? '2024-01-01 00:00:00',
                    'account_name' => $result->accountName ?? 'No Account',
                    'account_number' => $result->accountNumber ?? '0000000000',
                    'bank_name' => $result->sBankName ?? 'Unknown Bank',
                    'bank_code' => $result->bank_code ?? '000',
                    'current_balance' => strval($result->sWallet ?? '0'),
                    'login_status' => $result->sLastActivity ? 'Online' : 'Offline',
                    'admin_status' => $result->sType == 2, // Assuming sType 2 is admin
                    'isbank_verify' => $result->sVerified ?? 'no',
                    'user_type' => $result->sType,
                    'refwallet' => strval($result->sRefWallet ?? '0'),
                    'pin' => strval($result->sPin ?? '1234'),
                    'pin_set' => strval($result->sPin ?? '1234'),
                    'vercode' => $result->sVerCode ?? '0000',
                    'apikey' => $result->sApiKey ?? 'N/A',
                    'notif' => $result->sFcm ?? 'None',
                    'wema' => $result->sBankNo ?? '1',
                    'payvessel' => $result->sPayvesselBank ?? '1',
                    'moniepoint' => $result->sRolexBank ?? '1',
                    'charges' => $result->sAccountLimit ?? '0',
                    'vtuaccount' => $result->sVpay ?? 'n',
                    'state' => $result->sState ?? 'Not Provided',
                    'device' => $result->sDevice ?? 'Unknown',
                    'device_check' => $result->sDeviceCheck ?? 'match',
                    'referral' => $result->sReferal ?? 'None',
                    'referral_code' => $result->sReferralCode ?? 'None',
                    'safe_haven' => $result->sSafeHaven ?? 'None',
                    'escrow' => strval($result->sEscrow ?? '0'),
                    'kuda_bank' => $result->sKudaBank ?? 'None',
                    'gt_bank' => $result->sGtBank ?? 'None',
                    'nin' => $result->sNIN ?? 'None',
                    'dob' => $result->sDOB ?? 'Unknown',
                    'bvn' => $result->sBVN ?? 'None',
                    'account_reference' => $result->sAccountReference ?? 'None',
                
                    'payment_point_bank' => $result->sPaymentPointBank ?? 'None',
                    'otp' => $result->sOtp ?? 'None',
                    'kyc_data' => $result->kyc_data ?? 'None',
                    'pocketfi_bank' => $result->sPocketFiBank ?? 'None',
                    'pocketfi_bank2' => $result->sPocketFiBank2 ?? 'None',
                    'sterling_bank' => $result->sSterlingBank ?? 'None',
                    'fidelity_bank' => $result->sFidelityBank ?? 'None',
                    'pay_vessel' => $result->sPayVessel ?? 'None',
                    'pin_status' => strval($result->sPinStatus ?? '0'),
                    'received_referral_bonus' => $result->received_referral_bonus ?? '0',
                    'addressHome' => $result->addressHome ?? 'None', // Added
                    'city' => $result->city ?? 'None', // Added
                    'lga' => $result->lga ?? 'None', // Added
                    'postalCode' => $result->postalCode ?? 'None', // Added
                    'verificationType' => $result->verificationType ?? 'None', // Added
                    'identityNumber' => $result->identityNumber ?? 'None', // Added
                    
                    'cashback' => $result->sCashBack ?? 'None', // Added
                ];

                // Log successful response
                file_put_contents('airtime_success_log.txt', json_encode($response, JSON_UNESCAPED_SLASHES));
                return $response;
            } else {
                $response = [
                    'status' => 'error',
                    'msg' => $id
                ];
                // Log error response
                file_put_contents('airtime_fail_log.txt', json_encode($response, JSON_UNESCAPED_SLASHES));
                return $response;
            }
        } catch (PDOException $e) {
            $response = [
                'status' => 'error',
                'msg' => 'Database error: ' . $e->getMessage()
            ];
            file_put_contents('airtime_fail_log.txt', json_encode($response, JSON_UNESCAPED_SLASHES));
            return $response;
        }
    }

    private function formatUserType($type) {
        switch ($type) {
            case '1':
                return 'guest';
            case '2':
                return 'admin';
            default:
                return 'guest';
        }
    }
}

// Usage
$controller = new UserController();
$result = $controller->fetchUser($_GET['id'] ?? 0);

if ($result['status'] === 'error') {
    header('HTTP/1.0 400 Invalid Network Id');
    echo json_encode($result, JSON_UNESCAPED_SLASHES);
    exit();
}

echo json_encode($result, JSON_UNESCAPED_SLASHES);
exit();
?>