<?php
 header('Access-Control-Allow-Origin: *');
    header('Content-Type: application/json');
    header("Access-Control-Allow-Methods: POST");
    header("Allow: GET, POST, OPTIONS, PUT, DELETE");
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Access-Control-Allow-Origin");

    require_once("../../autoloader.php");
    //Allowed API Headers
   
    // Initialize logging
    $logFile = 'api_log.txt'; // Define log file path
    $logData = array();
    
    // Capture request details
    $requestHeaders = apache_request_headers();
    $requestBody = file_get_contents('php://input'); // Get raw POST data
    $logData['request'] = array(
        'timestamp' => date('Y-m-d H:i:s'),
        'method' => $_SERVER['REQUEST_METHOD'],
        'uri' => $_SERVER['REQUEST_URI'],
        'headers' => $requestHeaders,
        'body' => $requestBody
    );

    $response = array();
    $controller = new ApiAccess;

    // -------------------------------------------------------------------
    //  Check For Api Authorization
    // -------------------------------------------------------------------

    if((isset($requestHeaders['Authorization']) || isset($requestHeaders['authorization'])) || (isset($requestHeaders['Token']) || isset($requestHeaders['token']))){
        if((isset($requestHeaders['Authorization']) || isset($requestHeaders['authorization']))){
            $token = trim(str_replace("Token", "", (isset($requestHeaders['Authorization'])) ? $requestHeaders['Authorization'] : $requestHeaders['authorization']));
        }
        if((isset($requestHeaders['Token']) || isset($requestHeaders['token']))){
            $token = trim(str_replace("Token", "", (isset($requestHeaders['Token'])) ? $requestHeaders['Token'] : $requestHeaders['token']));
        }
        $result = $controller->validateAccessToken($token);
        if($result["status"] == "fail"){
            // tell the user no products found
            header('HTTP/1.0 500 Unauthorized');
            $response["status"] = "fail";
            $response["msg"] = "";
            $logData['response'] = $response;
            // Log the data
            file_put_contents($logFile, json_encode($logData, JSON_PRETTY_PRINT) . "\n\n", FILE_APPEND);
            echo json_encode($response); exit(); 
        }
    }
    else{
        header('HTTP/1.0 500 Unauthorized');
        // tell the user no products found
        $response["status"] = "fail";
        $response["msg"] = "Your authorization token is required.";
        $logData['response'] = $response;
        // Log the data
        file_put_contents($logFile, json_encode($logData, JSON_PRETTY_PRINT) . "\n\n", FILE_APPEND);
        echo json_encode($response); exit(); 
    }

    // -------------------------------------------------------------------
    //  Get User Details
    // -------------------------------------------------------------------
    $response = $controller->getUserDetails($token);
    $response["status"] = "success";
    $logData['response'] = $response;
    // Log the data
    file_put_contents($logFile, json_encode($logData, JSON_PRETTY_PRINT) . "\n\n", FILE_APPEND);
    echo json_encode($response); exit();

?>