<?php

// Auto Load Classes
require_once("../../autoloader.php");
// Allowed API Headers
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header("Access-Control-Allow-Methods: POST");
header("Allow: POST, OPTIONS, PUT, DELETE");
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Access-Control-Allow-Origin");


$headers = apache_request_headers();
$response = array();
$controller = new Account;


// -------------------------------------------------------------------
// Check Request Method
// -------------------------------------------------------------------

$requestMethod = $_SERVER["REQUEST_METHOD"];
if ($requestMethod !== 'POST') {
    header('HTTP/1.0 200 Bad Request');
    $response["status"] = "fail";
    $response["msg"] = "Only POST method is allowed";
    echo json_encode($response);
    exit();
}

$input = @file_get_contents("php://input");
// decode the json file
$body = json_decode($input);

// Support Other API Format
$phone = (isset($body->phone)) ? $body->phone : "";
$accesspass = (isset($body->accesspass)) ? $body->accesspass : "";

$phone = strip_tags($phone);
$phone = filter_var($phone, FILTER_SANITIZE_STRING);
$accesspass = strip_tags($accesspass);
$accesspass = filter_var($accesspass, FILTER_SANITIZE_STRING);

// -------------------------------------------------------------------
// Check Inputs Parameters
// -------------------------------------------------------------------

$requiredField = "";

if ($phone === "") {
    $requiredField = "Phone Number Field Is Required";
}
if ($accesspass === "") {
    $requiredField = "Password Field Is Required";
}

if ($requiredField !== "") {
    header('HTTP/1.0 200 Success');
    $data = array(
        "status" => "unauthorized",
        "status_msg" => $requiredField,
    );
    $jsonString = json_encode($data, JSON_UNESCAPED_SLASHES);
    echo $jsonString;

    exit();
}

// -------------------------------------------------------------------
// Verify Details
// -------------------------------------------------------------------

$result = $controller->loginUserPin($phone, $accesspass);
if ($result["status"] == 0) {
    header('HTTP/1.0 200 Success');
    $data = array(
        "id" => $result["Id"],
        "user_name" => $result["username"] ?? "",
        "full_name" => $result["name"],
        "fname" => $result["fname"],
        "lname" => $result["lname"],
        "email" => $result["email"] ?? "dannvtu@gmail.com",
        "image_name" => $result["image"]  ?? "https://dannvtu.com.ng/userimages/default.jpg",
        "user_status" => "",
        "phone" => $result["phone"],
        "age" => $result["age"]  ?? "2024-12-43 00:00:98",
        "sex" => $result["sex"] ?? "Male",
        "address" => $result["address"],
        "date_created" => $result["date"] ?? "2024-12-43 00:00:98",
        "account_name" => "",
        "account_number" => "",
        "bank_name" => "",
        "bank_code" => "",
        "current_balance" => "",
        "login_status" => "",
        "admin_status" => true,
        "address" => $result["address"],
        "isbank_verify" => $result["isbank_verify"],
        "status" => "success",
        "user_type" => formatUserType($result["user_type"]),
        "refwallet" =>json_encode($result["refwallet"]),
        "pin" => json_encode($result["pin"]),
        "pin_set" => $result["pin_set"],
        "vercode" => $result["pin_set"],
        "apikey" => $result["apikey"],
        "notif" => $result["notif"],
        "wema" => $result["wema"] ?? "Loading..",
        "payvessel" => !empty($result["payvessel"]) ? $result["payvessel"] : "Loading..",
"moniepoint" => !empty($result["moniepoint"]) ? $result["moniepoint"] : "Loading..",

         "kuda" => $result["kuda"] ?? "Loading..",
         "fidelity" => $result["fidelity"] ?? "Loading..",
         "sterling" => $result["sterling"] ?? "Loading..",
        "charges" => $result["charges"] ?? "1",
        "vtuaccount" => $result["vtuaccount"] ?? "n"
    );
  
    $jsonString = json_encode($data, JSON_UNESCAPED_SLASHES);
    echo $jsonString;
    exit();
} elseif ($result["status"] == 1) {
    header('HTTP/1.0 200 Success');

    $data = array(
        "status" => "fail",
        "status_msg" => "Incorrect Login Details",
    );
    $jsonString = json_encode($data, JSON_UNESCAPED_SLASHES);
    echo $jsonString;
    exit();
} elseif ($result["status"] == 2) {
    header('HTTP/1.0 200 Success');

    $data = array(
        "status" => "blocked",
        "status_msg" => "Account Blocked, Please Contact Admin",
    );
    $jsonString = json_encode($data, JSON_UNESCAPED_SLASHES);
    echo $jsonString;

    exit();
    
} elseif ($result["status"] == 4) {
    header('HTTP/1.0 200 Success');

    $data = array(
        "status" => "fail",
        "status_msg" => "Incorrect Login Details",
    );
    $jsonString = json_encode($data, JSON_UNESCAPED_SLASHES);
    echo $jsonString;

    exit();
} else {
    header('HTTP/1.0 500 Unauthorized');
    $response['status'] = "unauthorized";
    $response['msg'] = "Unauthorized Access";
    echo json_encode($response);
    exit();
}

function formatUserType($value)
{
    $value = (float) $value;
    $output = "";
    if ($value == 1) {
        $output = "Smart";
    } elseif ($value == 2) {
        $output = "API";
    } else {
        $output = "Vendor";
    }
    return $output;
}
